using System;
using System.Data;
using System.Collections.Generic;
using System.Text;

namespace DataSet1
{
   class Program
   {
      static void Main(string[] args)
      {
         // stwrz pusty zbir danych o nowej strukturze
         DataSet ds = new DataSet();
         DataTable customers = new DataTable("Customers");
         customers.Columns.Add(new DataColumn("CustomerId", typeof(int)));
         customers.Columns[0].AutoIncrement = true;
         customers.Columns[0].AutoIncrementSeed = 1;
         customers.PrimaryKey = new DataColumn[] { customers.Columns[0] };
         customers.Columns.Add(new DataColumn("CustomerName", typeof(string)));
         customers.Columns.Add(new DataColumn("Email", typeof(string)));
         customers.Constraints.Add(new UniqueConstraint(customers.Columns["Email"]));
         ds.Tables.Add(customers);

         DataRow newCustomer = customers.NewRow();
         newCustomer["CustomerName"] = "Jan Kowalski";
         newCustomer["Email"] = "jan.kowalski@jakisserwer.com";
         customers.Rows.Add(newCustomer);

         newCustomer = customers.NewRow();
         newCustomer["CustomerName"] = "Joanna Kowalska";
         newCustomer["Email"] = "joanna.kowalska@jakisserwer.com";
         customers.Rows.Add(newCustomer);

         // wykonaj wyszukiwanie w tabeli klientw
         DataRow[] custMatch = customers.Select("Email = 'joanna.kowalska@jakisserwer.com'");
         foreach (DataRow customer in custMatch)
         {
            Console.WriteLine(
             string.Format("Klient {0}({1}) zosta wyszukany na podstawie adresu e-mail: {2}",
             customer["CustomerName"], customer["CustomerId"], customer["Email"]));
         }
         Console.ReadLine();
      }
   }
}
